<?php

class AopsEntryManager {

	protected $db;
	protected $tableName;

	public function __construct() {
		global $wpdb;
		$this->db = $wpdb;
		$this->tableName = $wpdb->prefix . 'cu_entries';

	}

	/**
	 * Saves an entry
	 * @param AopsEntry $entry
	 */
	public function save($entry) {
		$this->db->insert($this->tableName, array(
			"cu_id"			=> $entry->cuId,
			"name"			=> $entry->name,
			"email"			=> $entry->email,
			"created_at"	=> $entry->created_at
			),
			array("%d", "%s", "%s", "%s")
		);
	}

	public function checkForDuplicates($entry) {
		if (get_class($entry) == 'AopsEntry') {
			$emailEntries = $this->getEntriesByEmail($entry->email);

			$lastTime = strtotime($entry->created_at);

			$duplicatesCount = 0;
			foreach ($emailEntries as $emailEntry) {
				$prevTime = strtotime($emailEntry->created_at);

				if ($lastTime - $prevTime < 30) {
					$duplicatesCount++;
				}
			}
			if ($duplicatesCount === 0) {
				return true;
			}
		}
		return false;
	}

	public function getEntriesByEmail($email) {
		$sql = $this->db->prepare("SELECT * FROM " . $this->tableName . " WHERE email = '%s'", $email);
		$entries = $this->db->get_results($sql);
		return $entries;
	}


	/**
	 * Get number of entries for Content Upgrade
	 * @param integer $cuId
	 * @return array
	 */
	public static function getCuEntriesNumber($cuId) {
		global $wpdb;
		$tableName = $wpdb->prefix . 'cu_entries';
		$sql = $wpdb->prepare("SELECT count(*) as 'count' FROM " . $tableName . " WHERE cu_id = %d", $cuId);

		$result = $wpdb->get_row($sql);
		return $result->count;
	}


}
?>
